class Lionel < Enemy
  def initialize(args, info)
    super

    @position.x = info.position.x
    @position.y = info.position.y

    @path = "sprites/enemies/lionel.png"

    @direction = :south
    @last_direction_change_time = args.state.tick_count

    @move_directions = @@VALID_DIRECTIONS.copy
    @walk_frame = 0
  end

  def tick(args)
    if args.state.tick_count - @last_direction_change_time > 20
      @last_direction_change_time = args.state.tick_count
      @direction = @move_directions.sample
      if (check = rand()) >= 0.85
        @move_directions -= [@direction]
      end
      if @move_directions.empty?
        @move_directions = @@VALID_DIRECTIONS.copy
      end
    end
    rect = args.state.room_rect.copy
    rect.x, rect.y = 0, 0

    if collision_rect.inside_rect?(rect)
    # if point_inside_rect?(rect)
      move(@direction)
      @walk_frame = (@walk_frame + 1) % 2
    else
      @direction = opposide_direction(@direction)
      move(@direction)
    end
  end
  
  def move(direction)
    case direction
    when :north
      @position.y += 1
    when :south
      @position.y -= 1
    when :east
      @position.x -= 1
    when :west
      @position.x += 1
    end
  end

  def render
    
  end

  def source_x
    case @direction
    when :south
      0 #+ (@walk_frame * 32)
    when :north
      32
    when :east, :west
      64 + (@walk_frame * 32)
    end
  end
  def source_y
    0
  end

  def flip_horizontally
    facing_east = @direction == :east
    if facing_east && @walk_frame == 1
      return true
    end
    facing_east
  end
  def flip_vertically
    @direction == :north
  end

  def source_w
    32 
  end
  def source_h
    32
  end
end